# Function runs once per second

# # Sleep with the Fishes (stay underwater)
execute as @a at @s if block ~ ~ ~ #minecraft:underwater_blocks run scoreboard players add @a hc_underwater 1
execute as @a at @s unless block ~ ~ ~ #minecraft:underwater_blocks run scoreboard players set @s hc_underwater 0
execute as @a at @s if block ~ ~1.7 ~ #minecraft:non_underwater_blocks run scoreboard players set @s hc_underwater 0
advancement grant @a[scores={hc_underwater=1200..}] only hobbitcraft:challenges/sleep_with_the_fishes

# All mobs with Wave set to 1 or higher (part of a raid) get given a special tag for being detected by advancements
execute as @e[type=#minecraft:raiders] store result score @s hc_part_of_raid run data get entity @s Wave
tag @e[type=#minecraft:raiders,scores={hc_part_of_raid=1..}] add part_of_raid

# # Castaway
# If the player eats dried kelp their score begins to go up once per second
execute as @a[advancements={hobbitcraft:technical/castaway_start=true}] run scoreboard players add @s hc_castaway 1

# After three days they obtain the advancement
advancement grant @a[scores={hc_castaway=3600..}] only hobbitcraft:challenges/castaway

# If the player eats anything other than dried kelp they lose their progress and castaway_start is cleared
execute as @a[advancements={hobbitcraft:technical/castaway_fail=true}] run function hobbitcraft:castaway_fail


# # On A Rail
execute as @a at @s if score @s hc_oar_eligible_x matches 1 run function hobbitcraft:on_a_rail_check
execute as @a at @s unless score @s hc_oar_eligible_x matches 1 if score @s hc_oar_eligible_z matches 1 run function hobbitcraft:on_a_rail_check

# All mobs with Wave set to 1 or higher (part of a raid) get given a special tag for being detected by advancements
execute as @e[type=#minecraft:raiders] store result score @s hc_part_of_raid run data get entity @s Wave
tag @e[type=#minecraft:raiders,scores={hc_part_of_raid=1..}] add part_of_raid

# # Just Keeps Going
# If the player eats rabbit stew their score begins to go up once per second
scoreboard players add @a[scores={hc_just_keep=1..}] hc_just_keep 1
execute as @a[advancements={hobbitcraft:technical/just_keeps_going_start=true}] run function hobbitcraft:just_keeps_going

# After three days they obtain the advancement
advancement grant @a[scores={hc_just_keep=3600..}] only hobbitcraft:challenges/just_keeps_going

# If the player eats anything while in progress they lose their progress and just_keeps_going_start is cleared
execute as @a[advancements={hobbitcraft:technical/just_keeps_going_fail=true}] run function hobbitcraft:just_keeps_going_fail


# # A Wizard's Breakfast
# If the player eats chorus fruit their timer score begins to go down
scoreboard players remove @a[scores={hc_wiz_break=1..,hc_chorus_reset=1..}] hc_chorus_reset 1
execute as @a[advancements={hobbitcraft:technical/a_wizards_breakfast=true}] run function hobbitcraft:a_wizards_breakfast

# If the player reaches 64 chorus fruit they obtain the advancement
advancement grant @a[scores={hc_wiz_break=64..}] only hobbitcraft:challenges/a_wizards_breakfast

# If the player eats anything while in progress OR the time runs out they lose their progress
execute as @a[advancements={hobbitcraft:technical/a_wizards_breakfast_fail=true}] run function hobbitcraft:a_wizards_breakfast_fail
execute as @a[scores={hc_chorus_reset=0}] run function hobbitcraft:a_wizards_breakfast_fail

# # Let Me Out!
# If the player is in the Nether their score goes up once per second
scoreboard players add @a[predicate=hobbitcraft:in_the_nether] hc_let_me_out 1

# After twenty days (six hours and forty minutes) they obtain the advancement
advancement grant @a[scores={hc_let_me_out=24000..}] only hobbitcraft:challenges/let_me_out

# If the player is not in the Nether they lose their progress
execute as @a unless entity @s[predicate=hobbitcraft:in_the_nether] run scoreboard players set @s hc_let_me_out 0

# # Skill Issue
# Counts up once per second
scoreboard players add @a hc_loser 1

# If a player dies the count is reset. If less than 10 seconds are on the count, the "Skill Issue" advancement is granted
execute as @a[scores={hc_loser_death=1..}] run function hobbitcraft:skill_issue

# # A Piglin's Best Friend
# If a player gives gold to a piglin, a score goes up
execute as @a[advancements={hobbitcraft:technical/give_piglin_gold=true}] at @s run function hobbitcraft:give_piglin_gold

# # Rocketman (fill inventory with stacks of firework rockets)
execute as @a[nbt={Inventory:[{Slot:24b,id:"minecraft:firework_rocket",Count:64b}]}] if entity @s[nbt={Inventory:[{Slot:0b,id:"minecraft:firework_rocket",Count:64b},{Slot:1b,id:"minecraft:firework_rocket",Count:64b},{Slot:2b,id:"minecraft:firework_rocket",Count:64b},{Slot:3b,id:"minecraft:firework_rocket",Count:64b},{Slot:4b,id:"minecraft:firework_rocket",Count:64b},{Slot:5b,id:"minecraft:firework_rocket",Count:64b},{Slot:6b,id:"minecraft:firework_rocket",Count:64b},{Slot:7b,id:"minecraft:firework_rocket",Count:64b},{Slot:8b,id:"minecraft:firework_rocket",Count:64b},{Slot:9b,id:"minecraft:firework_rocket",Count:64b},{Slot:10b,id:"minecraft:firework_rocket",Count:64b},{Slot:11b,id:"minecraft:firework_rocket",Count:64b},{Slot:12b,id:"minecraft:firework_rocket",Count:64b},{Slot:13b,id:"minecraft:firework_rocket",Count:64b},{Slot:14b,id:"minecraft:firework_rocket",Count:64b},{Slot:15b,id:"minecraft:firework_rocket",Count:64b},{Slot:16b,id:"minecraft:firework_rocket",Count:64b},{Slot:17b,id:"minecraft:firework_rocket",Count:64b},{Slot:18b,id:"minecraft:firework_rocket",Count:64b},{Slot:19b,id:"minecraft:firework_rocket",Count:64b},{Slot:20b,id:"minecraft:firework_rocket",Count:64b},{Slot:21b,id:"minecraft:firework_rocket",Count:64b},{Slot:22b,id:"minecraft:firework_rocket",Count:64b},{Slot:23b,id:"minecraft:firework_rocket",Count:64b},{Slot:25b,id:"minecraft:firework_rocket",Count:64b},{Slot:26b,id:"minecraft:firework_rocket",Count:64b},{Slot:27b,id:"minecraft:firework_rocket",Count:64b},{Slot:28b,id:"minecraft:firework_rocket",Count:64b},{Slot:29b,id:"minecraft:firework_rocket",Count:64b},{Slot:30b,id:"minecraft:firework_rocket",Count:64b},{Slot:31b,id:"minecraft:firework_rocket",Count:64b},{Slot:32b,id:"minecraft:firework_rocket",Count:64b},{Slot:33b,id:"minecraft:firework_rocket",Count:64b},{Slot:34b,id:"minecraft:firework_rocket",Count:64b},{Slot:35b,id:"minecraft:firework_rocket",Count:64b},{Slot:-106b,id:"minecraft:firework_rocket",Count:64b}]}] run advancement grant @s only hobbitcraft:challenges/rocketman

# # Immortal (fill inventory with Totems of Undying)
execute as @a[nbt={Inventory:[{Slot:24b,id:"minecraft:totem_of_undying",Count:1b}]}] if entity @s[nbt={Inventory:[{Slot:0b,id:"minecraft:totem_of_undying",Count:1b},{Slot:1b,id:"minecraft:totem_of_undying",Count:1b},{Slot:2b,id:"minecraft:totem_of_undying",Count:1b},{Slot:3b,id:"minecraft:totem_of_undying",Count:1b},{Slot:4b,id:"minecraft:totem_of_undying",Count:1b},{Slot:5b,id:"minecraft:totem_of_undying",Count:1b},{Slot:6b,id:"minecraft:totem_of_undying",Count:1b},{Slot:7b,id:"minecraft:totem_of_undying",Count:1b},{Slot:8b,id:"minecraft:totem_of_undying",Count:1b},{Slot:9b,id:"minecraft:totem_of_undying",Count:1b},{Slot:10b,id:"minecraft:totem_of_undying",Count:1b},{Slot:11b,id:"minecraft:totem_of_undying",Count:1b},{Slot:12b,id:"minecraft:totem_of_undying",Count:1b},{Slot:13b,id:"minecraft:totem_of_undying",Count:1b},{Slot:14b,id:"minecraft:totem_of_undying",Count:1b},{Slot:15b,id:"minecraft:totem_of_undying",Count:1b},{Slot:16b,id:"minecraft:totem_of_undying",Count:1b},{Slot:17b,id:"minecraft:totem_of_undying",Count:1b},{Slot:18b,id:"minecraft:totem_of_undying",Count:1b},{Slot:19b,id:"minecraft:totem_of_undying",Count:1b},{Slot:20b,id:"minecraft:totem_of_undying",Count:1b},{Slot:21b,id:"minecraft:totem_of_undying",Count:1b},{Slot:22b,id:"minecraft:totem_of_undying",Count:1b},{Slot:23b,id:"minecraft:totem_of_undying",Count:1b},{Slot:25b,id:"minecraft:totem_of_undying",Count:1b},{Slot:26b,id:"minecraft:totem_of_undying",Count:1b},{Slot:27b,id:"minecraft:totem_of_undying",Count:1b},{Slot:28b,id:"minecraft:totem_of_undying",Count:1b},{Slot:29b,id:"minecraft:totem_of_undying",Count:1b},{Slot:30b,id:"minecraft:totem_of_undying",Count:1b},{Slot:31b,id:"minecraft:totem_of_undying",Count:1b},{Slot:32b,id:"minecraft:totem_of_undying",Count:1b},{Slot:33b,id:"minecraft:totem_of_undying",Count:1b},{Slot:34b,id:"minecraft:totem_of_undying",Count:1b},{Slot:35b,id:"minecraft:totem_of_undying",Count:1b},{Slot:-106b,id:"minecraft:totem_of_undying",Count:1b}]}] run advancement grant @s only hobbitcraft:super_challenges/immortal

# # Small Build (fill inventory with Shulkers of Glass)
execute as @a[nbt={Inventory:[{Slot:24b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b}]}] if entity @s[nbt={Inventory:[{Slot:0b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:1b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:2b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:3b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:4b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:5b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:6b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:7b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:8b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:9b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:10b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:11b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:12b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:13b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:14b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:15b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:16b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:17b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:18b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:19b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:20b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:21b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:22b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:23b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:25b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:26b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:27b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:28b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:29b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:30b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:31b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:32b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:33b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:34b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:35b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b},{Slot:-106b,id:"minecraft:shulker_box",tag:{BlockEntityTag:{Items:[{Count:64b,Slot:0b,id:"minecraft:glass"},{Count:64b,Slot:1b,id:"minecraft:glass"},{Count:64b,Slot:2b,id:"minecraft:glass"},{Count:64b,Slot:3b,id:"minecraft:glass"},{Count:64b,Slot:4b,id:"minecraft:glass"},{Count:64b,Slot:5b,id:"minecraft:glass"},{Count:64b,Slot:6b,id:"minecraft:glass"},{Count:64b,Slot:7b,id:"minecraft:glass"},{Count:64b,Slot:8b,id:"minecraft:glass"},{Count:64b,Slot:9b,id:"minecraft:glass"},{Count:64b,Slot:10b,id:"minecraft:glass"},{Count:64b,Slot:11b,id:"minecraft:glass"},{Count:64b,Slot:12b,id:"minecraft:glass"},{Count:64b,Slot:13b,id:"minecraft:glass"},{Count:64b,Slot:14b,id:"minecraft:glass"},{Count:64b,Slot:15b,id:"minecraft:glass"},{Count:64b,Slot:16b,id:"minecraft:glass"},{Count:64b,Slot:17b,id:"minecraft:glass"},{Count:64b,Slot:18b,id:"minecraft:glass"},{Count:64b,Slot:19b,id:"minecraft:glass"},{Count:64b,Slot:20b,id:"minecraft:glass"},{Count:64b,Slot:21b,id:"minecraft:glass"},{Count:64b,Slot:22b,id:"minecraft:glass"},{Count:64b,Slot:23b,id:"minecraft:glass"},{Count:64b,Slot:24b,id:"minecraft:glass"},{Count:64b,Slot:25b,id:"minecraft:glass"},{Count:64b,Slot:26b,id:"minecraft:glass"}]}},Count:1b}]}] run advancement grant @s only hobbitcraft:super_challenges/small_build

# # Family Reunion
execute as @a at @s if entity @e[type=husk,tag=!hc_baby,distance=..5] if entity @e[type=zombie_villager,tag=!hc_baby,distance=..5] if entity @e[type=drowned,tag=!hc_baby,distance=..5] if entity @e[type=zombified_piglin,tag=!hc_baby,distance=..5] if entity @e[type=zombie,tag=!hc_baby,distance=..5] if entity @e[type=husk,tag=hc_baby,distance=..5] if entity @e[type=zombie_villager,tag=hc_baby,distance=..5] if entity @e[type=drowned,tag=hc_baby,distance=..5] if entity @e[type=zombified_piglin,tag=hc_baby,distance=..5] if entity @e[type=zombie,tag=hc_baby,distance=..5] run advancement grant @s only hobbitcraft:challenges/family_reunion

# # Bone-to-Party
execute as @a at @s if entity @e[type=skeleton_horse,distance=..5] if entity @e[type=wither,distance=..5] if entity @e[type=stray,distance=..5] if entity @e[type=wither_skeleton,distance=..5] if entity @e[type=skeleton,distance=..5] run advancement grant @s only hobbitcraft:challenges/bone_to_party

# # Event Horizon
advancement revoke @a[predicate=!hobbitcraft:in_the_end] only hobbitcraft:technical/below_void

# A player gains the score '1' in event_horizon upon going below the void
execute as @a[scores={hc_health=1..},advancements={hobbitcraft:technical/below_void=true}] run function hobbitcraft:below_void

# If the player dies they lose the score
## Command in tick

# If the player makes it above y = 0 they gain the advancement
execute as @a[advancements={hobbitcraft:technical/return_from_void=true},scores={hc_eventhorizon=1}] run advancement grant @s only hobbitcraft:challenges/event_horizon


# # Dragon vs Dragon
# A player gains the score '1' in hc_dvd upon respawning the dragon
execute as @a[advancements={blazeandcave:technical/respawn_dragon=true}] run scoreboard players set @s hc_dvd 1

# It is set back to '0' if they are not wearing a dragon head, which will disqualify their eligibility for obtaining this advancement
execute as @a[scores={hc_dvd=1}] unless entity @s[predicate=blazeandcave:wear_dragon_head] run scoreboard players set @s hc_dvd 0

# If the player successfully kills the Ender Dragon still with a score of '1' they will gain the advancement
execute as @a[advancements={blazeandcave:technical/kill_dragon=true},scores={hc_dvd=1}] run advancement grant @s only blazeandcave:end/dragon_vs_dragon


 # Dragon vs Dragon II: Electric Boogaloo
# A player gains the score '1' in hc_dvd2eb upon respawning the dragon
execute as @a[advancements={hobbitcraft:technical/respawn_dragon=true}] run function hobbitcraft:dvd2eb_start

# It is set back to '0' if they touch the ground OR are not wearing a dragon head, which will disqualify their eligibility for obtaining this advancement
# Players are also disqualified for touching water, lava, or riding any vehicle
execute as @a[scores={hc_dvd2eb=1}] unless entity @s[nbt={OnGround:0b},predicate=hobbitcraft:wear_dragon_head] run function hobbitcraft:dvd2eb_fail
execute as @a[scores={hc_dvd2eb=1}] if entity @s[advancements={hobbitcraft:technical/fail_dragon_vs=true}] run function hobbitcraft:dvd2eb_fail

# If the player successfully kills the Ender Dragon still with a score of '1' they will gain the advancement
execute as @a[advancements={hobbitcraft:technical/kill_dragon=true},scores={hc_dvd2eb=1}] run advancement grant @s only hobbitcraft:challenges/dragon_vs_dragon_ii_electric_boogaloo
execute as @a[advancements={hobbitcraft:technical/kill_dragon=true}] run advancement revoke @s only hobbitcraft:technical/kill_dragon


# # Dragon vs Wither: The Pre-Sequel
# A player gains the score '1' in hc_dveps upon respawning the wither
execute as @a[advancements={blazeandcave:technical/respawn_wither=true}] run function blazeandcave:dveps_start

# It is set back to '0' if they touch the ground OR are not wearing a dragon head OR more than 11 seconds has passed since spawning the Wither. Failing will disqualify their eligibility for obtaining this advancement
scoreboard players remove @a[scores={hc_withercool=1..}] hc_withercool 1
execute as @a[scores={hc_dveps=1}] unless score @s hc_withercool matches 1.. unless entity @s[nbt={OnGround:0b},predicate=blazeandcave:wear_dragon_head] run function blazeandcave:dveps_fail
execute as @a[scores={hc_dveps=1}] unless score @s hc_withercool matches 1.. if entity @s[advancements={blazeandcave:technical/fail_dragon_vs=true}] run function blazeandcave:dveps_fail

scoreboard players set @s hc_dveps 0

# If the player successfully kills the Wither still with a score of '1' they will gain the advancement
execute as @a[advancements={blazeandcave:technical/kill_wither=true},scores={hc_dveps=1}] run advancement grant @s only blazeandcave:challenges/dragon_vs_wither_the_pre_sequel
execute as @a[advancements={blazeandcave:technical/kill_wither=true}] run advancement revoke @s only blazeandcave:technical/kill_wither


# # The Perfect Run
# When spawning a Dragon, Wither or a Raid, the player has a time limit of thirty seconds to spawn the other two
execute as @a[advancements={hobbitcraft:technical/spawn_perfect_one=true}] unless score @s hc_pr_tl matches 1.. run function hobbitcraft:perfect_run_start
execute as @a[advancements={hobbitcraft:technical/spawn_perfect_one=false}] run advancement revoke @s only hobbitcraft:technical/spawn_perfect_all

# If all three are successfully spawned before thirty seconds elapses, the countdown timer stops
execute as @a[scores={hc_pr_tl=1..}] unless entity @s[advancements={hobbitcraft:technical/spawn_perfect_all=true}] run scoreboard players remove @s hc_pr_tl 1

# If the countdown timer reaches 0 then the player is disqualified
execute as @a[advancements={hobbitcraft:technical/spawn_perfect_one=true},scores={hc_pr_tl=0}] run function hobbitcraft:perfect_run_fail

# If the player takes damage at any stage then the player is disqualified
execute as @a[advancements={hobbitcraft:technical/spawn_perfect_one=true},scores={hc_pr_dmgt=1..}] run function hobbitcraft:perfect_run_fail
execute as @a[advancements={hobbitcraft:technical/spawn_perfect_one=true},scores={hc_pr_dmga=1..}] run function hobbitcraft:perfect_run_fail
execute as @a[advancements={hobbitcraft:technical/spawn_perfect_one=true},scores={hc_pr_dmgr=1..}] run function hobbitcraft:perfect_run_fail

# If the player successfully lands the killing blow on the Dragon, Wither, and wins the Raid, the advancement is granted
# Once all three are spawned, the player has unlimited time to do all of these. The only condition is that they cannot take damage

# # House of Freaks
execute as @a at @s if entity @e[type=warden,distance=..16] run function hobbitcraft:count_wardens

# # Animal Kingdom
execute as @a at @s if entity @e[type=mule,distance=..32] run function hobbitcraft:animal_kingdom_check

# # Captain America (stay in powder snow)
execute as @a at @s run function hobbitcraft:captain_america

# # Riddle Me This
# For the tenth line, it only starts counting once the player has completed the ninth line
execute as @a[advancements={hobbitcraft:technical/riddle_ninth_line=false}] run scoreboard players set @s hc_1000th_item 0

# Once they have placed 1000 Warped Buttons, the tenth line is complete
execute as @a[advancements={hobbitcraft:technical/riddle_ninth_line=true}] if score @s hc_1000th_item matches 1000.. run advancement grant @s only hobbitcraft:technical/riddle_tenth_line


schedule function hobbitcraft:one_second_timer 1s