# Function runs once every ten seconds

# For "An Apple a Day" if an apple is eaten it increases the score. hc_apple_eaten is then set to 100
execute as @a[scores={hc_apple_eaten=1..99}] run scoreboard players add @s hc_apple_days 1
execute as @a[scores={hc_apple_eaten=1..}] run scoreboard players set @s hc_apple_eaten 100

# Once reaching 30 consecutive days "An Apple a Day" is awarded
execute as @a[scores={hc_apple_days=30..}] at @s run advancement grant @s only hobbitcraft:challenges/an_apple_a_day

# Gives baby zombie variants the 'baby' tag if they are a baby (Used for the "Family Reunion" advancement)
execute as @e[type=#minecraft:zombies,tag=!hc_baby] run tag @s[nbt={IsBaby:1b}] add hc_baby

# Day count is increased by 1 at each sunrise
scoreboard players operation previous hc_current_time = time hc_current_time
execute store result score time hc_current_time run time query daytime
execute if score time hc_current_time matches 0..200 run function hobbitcraft:increase_day

# If it is just before a sunrise players gain "The First Night"
execute if score time hc_current_time matches 23000..23200 run advancement grant @a until hobbitcraft:statistics/the_first_night

# "The First Night" is also achieved upon sleeping through the night. Because sleeping resets the time back to zero, it checks if the previous time was far greater than the time now
scoreboard players operation previous hc_current_time -= time hc_current_time
execute unless score previous hc_current_time matches ..13000 run advancement grant @a until hobbitcraft:statistics/the_first_night

# The World Is Ending (counts ten withers)
execute as @a at @s store result score @s hc_ten_withers run execute if entity @e[type=wither,distance=..128]
execute as @a if score @s hc_ten_withers matches 10.. run advancement grant @s only hobbitcraft:super_challenges/the_world_is_ending

schedule function hobbitcraft:ten_second_timer 10s